<?php

/*
 * This file was automatically generated.
 */
namespace Syde\Vendor\Worldline\OnlinePayments\Sdk\Domain;

use UnexpectedValueException;
/**
 * @package OnlinePayments\Sdk\Domain
 */
class Transaction extends DataObject
{
    /**
     * @var AmountOfMoney
     */
    public $amount = null;
    /**
     * @return AmountOfMoney
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * @param AmountOfMoney
     */
    public function setAmount($value)
    {
        $this->amount = $value;
    }
    /**
     * @return object
     */
    public function toObject()
    {
        $object = parent::toObject();
        if (!\is_null($this->amount)) {
            $object->amount = $this->amount->toObject();
        }
        return $object;
    }
    /**
     * @param object $object
     * @return $this
     * @throws UnexpectedValueException
     */
    public function fromObject($object)
    {
        parent::fromObject($object);
        if (\property_exists($object, 'amount')) {
            if (!\is_object($object->amount)) {
                throw new UnexpectedValueException('value \'' . \print_r($object->amount, \true) . '\' is not an object');
            }
            $value = new AmountOfMoney();
            $this->amount = $value->fromObject($object->amount);
        }
        return $this;
    }
}
